/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FilenameFilter;

public class NewMCLDataFileFilter
implements FilenameFilter {
    private static final String TRACE_MASKT = "XMCLNMDT";
    private static final String TRACE_MASKF = "XMCLNMDF";
    private static final String TRACE_MASKD = "XMCLNMDD";
    private static final int MCL_FILE_NAME_LENGTH = 15;
    private static final int MCL_FILE_FIRST_DOT = 7;
    private static final int MCL_FILE_ZIP_START = 11;
    private static final char MCL_FILE_FIRST_LETTER = 'D';
    private static final String MCL_FILE_ZIP_STRING = ".zip";
    String testString;
    int testStringLength;
    int firstLevel;
    int lastLevel;
    boolean anyEC;

    public NewMCLDataFileFilter(String ecStream, int firstLevel, int lastLevel) {
        this.testString = 'D' + ecStream + ".";
        this.testStringLength = this.testString.length();
        this.firstLevel = firstLevel;
        this.lastLevel = lastLevel;
        this.anyEC = false;
        Trace.trace(TRACE_MASKT, "<> NewMCLDataFileFilter for [" + this.testString + "]");
    }

    public NewMCLDataFileFilter() {
        this.anyEC = true;
        Trace.trace(TRACE_MASKT, "<> NewMCLDataFileFilter for all MCLs in all ECs.");
    }

    public boolean accept(File dir, String name) {
        Trace.trace(TRACE_MASKD, "-> accept(" + name + ")");
        if (15 != name.length()) {
            Trace.trace(TRACE_MASKD, "<- accept() returns false");
            return false;
        }
        boolean inec = false;
        if (this.anyEC) {
            int dotPosition;
            if ('D' == name.charAt(0) && 7 == (dotPosition = name.indexOf("."))) {
                String zip;
                String number = name.substring(8, 11);
                boolean allDigits = true;
                int i = 0;
                while (i < number.length()) {
                    if (!Character.isDigit(number.charAt(i))) {
                        allDigits = false;
                        break;
                    }
                    ++i;
                }
                if (allDigits && (zip = name.substring(11)).equals(MCL_FILE_ZIP_STRING)) {
                    inec = true;
                }
            }
        } else {
            String zip;
            String compareString = name.substring(0, this.testStringLength);
            if (compareString.equals(this.testString) && (zip = name.substring(11)).equals(MCL_FILE_ZIP_STRING)) {
                String number = name.substring(8, 11);
                boolean allDigits = true;
                int i = 0;
                while (i < number.length()) {
                    if (!Character.isDigit(number.charAt(i))) {
                        allDigits = false;
                        break;
                    }
                    ++i;
                }
                if (allDigits) {
                    int level = Integer.parseInt(number);
                    Trace.trace(TRACE_MASKD, "level = " + level);
                    if (level >= this.firstLevel && level <= this.lastLevel) {
                        inec = true;
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKD, "<- accept() returns " + inec);
        return inec;
    }
}

